This for a birdie!
==================

A 3D golf game for the Commodore 64 microcomputer.

Copyright 2018 Matthew Clarke

Entered for the [Forum64 & Protovision Game Competition 2017](https://www.protovision.games/compos/2017/compo.php?language=en).

## CONTENTS

1. [Introduction](#intro)
2. [Title screen](#title)
3. [Gameplay](#gameplay)
4. [In-game options](#options)
5. [Course maps](#maps)
6. [Club statistics](#clubs)
7. [Known bugs](#bugs)
8. [Technical](#technical)
9. [And...](#and...)

<a name="intro"></a>
INTRODUCTION
------------
Welcome to Beechings Golf & Country Club!

Practise your golfing skills on our magnificent 18\* holes set in an idyllic (and surprisingly flat!) corner of North Yorkshire, England.

Tree-lined fairways, shimmering lakes and immaculate greens as well as fiendish bunkers will provide you and your friends with, we hope, an enjoyable and challenging experience.

\* You may notice a remarkable similarity between the first 9 holes and the second 9. (Refunds are at the management's discretion...)

<a name="title"></a>
TITLE SCREEN
------------
![](titlescreen1.png)

You need a joystick in port #2 to navigate the title screen.

The game supports up to 4 players and 2 joysticks.

* Type your name at the flashing cursor and press *RETURN* when finished.  The letters A-Z and hyphen are allowed.
* Now select your gender (joystick left/right) and skin tone (joystick up/down) and press the fire button to confirm.
* Select your control method (joystick left/right) and again press the fire button to confirm.

Repeat this for any other players.  Pressing *RETURN* at the flashing cursor (without entering a name) will skip over the remaining slots and take you to the *WEATHER* option.

Select the weather with joystick left/right and confirm with the fire button.  This is really the game's difficulty setting and determines how much the wind will affect your game once out on the links.

The text *TO THE LINKS!* will now be highlighted.  Press the fire button to start the game!

<a name="gameplay"></a>
GAMEPLAY
--------
Firstly, here is an explanation of the 'stats' panel at the top of the screen.

![](statspanel.png)

1. Current player's name and overall score. Even par ('E') is drawn in white, below par (e.g. '-2') in red and above par (e.g. '+1') in green.
2. Number of shots taken so far for the current hole. While the ball is in motion, this number will 'pulse', and increment by one as soon as the ball stops.
3. Currently-selected club.  Change this with joystick up/down.
4. Distance from the hole. If you're on the green (and armed with a putter), this value will be in feet; otherwise in yards.
5. Details for the current hole. These should be fairly self-explanatory.  When you're on the putting green, the value for wind (in mph) will be replaced by the value for the slope (as a gradient).
6. Camera shake icon. If this is highlighted, the camera shake is enabled; or if it's greyed out (as in this screenshot), disabled.
7. Wind/slope indicator.  Shows the direction of the wind/slope vector.  

### SWING
![](liningup.png)

Select your club with joystick up/down.

Position your shot with joystick left/right - the 'pulsing' crosshair will move accordingly. If there's a strong cross-wind, you might want to take that also into account.

To start the swing, press and hold the fire button.  While you're holding the button down the shot is 'powering up' - the club shaft will turn grey to indicate this.

![](poweringup.png "Powering up - indicated by grey club shaft")

Release the fire button when you think you have enough power or, for maximum power, keep pressing the button until the very top of the swing - the club shaft will turn black again when this point is reached.

On the downward swing you may press the fire button once to determine the precision/spin of the shot.

![](swing_precision.png)

The two arcs of that circle, labelled *hook* and *slice*, make up the precision zone of the downswing. During this period the club shaft will turn grey unless/until you've pressed the fire button. If you press the fire button before you (or rather, your club head) reaches this zone, your shot will have maximum hook; if you press the button after you've exited this zone, or don't press the button at all, your shot will have maximum slice.

For as straight a shot as possible, try to press the fire button as the club head makes contact with the ball. The relevant sound effect, as well as camera shake (if it's enabled), may help you to determine when this contact happens.

**NOTE:** Hook makes the ball swerve to the left; slice to the right.

### TERRAIN
There are four types of terrain: fairway/green, rough, bunker and water.

If your ball lands in water, you must take the shot again.

In the rough and bunkers, the maximum power your club can generate is reduced by 1/3 and 1/2 respectively.  

Also, if you're in a bunker, the precision zone for your downswing is much shorter. You have to press the fire button at or just before the club head strikes the ball, otherwise you'll 'scuff' the shot (- the ball will just hop forward a few inches). And you have to use the sand wedge - no other club selection is allowed.

### PUTTING
The mechanism is the same as for the swing but there is no second button press required for precision. You just need to set the power of the putt by pressing, holding and releasing the fire button at the appropriate moments - or leave the button depressed for maximum power.

Once the ball has stopped moving and the golfer's animation has completed, you can press the fire button to advance to the next player/shot.

### PLAYING ORDER
When you begin the round, players are in the same order as they were entered on the title screen.

After everyone has teed off, the next player to go is the one furthest from the hole. 

At the beginning of subsequent holes, playing order is based on overall scores - the lowest score (i.e. the best player) goes first.

<a name="options"></a>
IN-GAME OPTIONS
---------------
These can be set while your golfer is lining up their shot.

* **F1** - toggle camera shake on/off
* **F3** - cycle through the border colors (in case you don't like black)
* **F5** - change the sky color (it can be either cyan or light grey)

<a name="maps"></a>
COURSE MAPS
-----------

(Note to self: **BETTER MAPS NEEDED!**)

Hole #1<br />
Par: 3<br />
Distance: 161 yds<br />
<img src="maps/hole1.png" border=3 />

Hole #2<br />
Par: 3<br />
Distance: 210 yds<br />
<img src="maps/hole2.png" border=3 />

Hole #3<br />
Par: 4<br />
Distance: 390 yds<br />
<img src="maps/hole3.png" border=3 />

Hole #4<br />
Par: 4<br />
Distance: 240 yds<br />
<img src="maps/hole4.png" border=3 />

Hole #5<br />
Par: 4<br />
Distance: 220 yds<br />
<img src="maps/hole5.png" border=3 />

Hole #6<br />
Par: 5<br />
Distance: 550 yds<br />
<img src="maps/hole6.png" border=3 />

Hole #7<br />
Par: 5<br />
Distance: 443 yds<br />
<img src="maps/hole7.png" border=3 />

Hole #8<br />
Par: 3<br />
Distance: 210 yds<br />
<img src="maps/hole8.png" border=3 />

Hole #9<br />
Par: 3<br />
Distance: 183 yds<br />
<img src="maps/hole9.png" border=3 />


<a name="clubs"></a>
CLUB STATISTICS
---------------
Speed (at launch), apex and carry for all clubs (except putter). These should be taken as a guide rather than gospel. These figures also assume maximum power, no wind and zero spin (hook/slice).

NOTE: *DR* = driver, *W* = wood, *I* = iron, *PW* = pitching wedge, *SW* = sand wedge.

<table>
  <tr>
    <th>CLUB</th>
    <th>SPEED (MPH)</th>
    <th>APEX (YDS)</th>
    <th>CARRY (YDS)</th>
  </tr>

  <tr>
    <td>DR</td>
    <td>140</td>
    <td>12</td>
    <td>241</td>
  </tr>

  <tr>
    <td>3W</td>
    <td>120</td>
    <td>14</td>
    <td>230</td>
  </tr>

  <tr>
    <td>5W</td>
    <td>105</td>
    <td>17</td>
    <td>215</td>
  </tr>

  <tr>
    <td>3I</td>
    <td>97</td>
    <td>18</td>
    <td>204</td>
  </tr>

  <tr>
    <td>4I</td>
    <td>88</td>
    <td>20</td>
    <td>194</td>
  </tr>

  <tr>
    <td>5I</td>
    <td>80</td>
    <td>20</td>
    <td>173</td>
  </tr>

  <tr>
    <td>6I</td>
    <td>73</td>
    <td>22</td>
    <td>163</td>
  </tr>

  <tr>
    <td>7I</td>
    <td>68</td>
    <td>23</td>
    <td>152</td>
  </tr>

  <tr>
    <td>8I</td>
    <td>64</td>
    <td>25</td>
    <td>145</td>
  </tr>

  <tr>
    <td>9I</td>
    <td>60</td>
    <td>26</td>
    <td>133</td>
  </tr>

  <tr>
    <td>PW</td>
    <td>56</td>
    <td>27</td>
    <td>120</td>
  </tr>

  <tr>
    <td>SW</td>
    <td>50</td>
    <td>27</td>
    <td>97</td>
  </tr>
</table>

<a name="bugs"></a>
KNOWN BUGS
----------
If you position the crosshair at the extreme left or right, and then swing with the driver (or most any other club), it might seem that the ball swerves into the middle of the screen in a manner not very true to the physics of the thing. This is an optical effect due to the camera having a very wide (certainly *too* wide) field of view. So when it looks like the ball should fly offscreen, the camera still projects it onto its *plate* and so it gets sucked back into the picture, so to speak. In the math routines under the hood (which you can't see), the ball is actually travelling directly straight, or at least as straight as spin and wind effects allow.

Tree trunks are entirely non-interactive. Both the ball and flag sprites don't know anything about them so they won't be drawn correctly with respect to depth, and ball-trunk collisions will never be recognized. This is a limitation of the graphics engine in its current form.

Sometimes your ball will land in the water (presumably!) but you won't here the *splash* sound effect and the scene will be re-rendered before you can take another shot. I don't know the cause of this yet.

There's occasional screen-flicker in response to a ball-tree collision. Quite a lot of processing goes on inside the raster interrupt so it misses the next one (i.e. the next raster interrupt), meaning the screen isn't updated correctly.

<a name="technical"></a>
TECHNICAL
---------
*This for a birdie!* is written in 6502 assembly with the venerable *acme* cross-assembler. My operating system is Xubuntu Linux 16.04 (LTS) 64-bit and my main text editor is gvim. They run on an HP Pavilion g6 laptop with an AMD E2-3000M and 4GB of RAM.

In no particular order, here's some of the other software I used to write the game:

* VICE (C64 emulator)
* gimp (raster graphics)
* inkscape (vector graphics)
* SpritePad
* CharPad
* GoatTracker 2
* mousepad (text editor)
* [base_converter](https://gitlab.com/matthewclarke/base_converter) (my own number-base converter thing)
* LibreOffice Calc (spreadsheets)
* markdown (a command-line program that turns markdown into html - it's how I'm writing this!)
* [Pike](http://pike.lysator.liu.se/) (an awesome scripting language)
* Perl (another awesome scripting language)
* bash (programmable shell)
* [Tiled](https://www.mapeditor.org/) (a tile-map editor - but with a bit of persuasion (and scripting) you can use it to edit quite a lot of other things)

<a name="and..."></a>
AND...
------
The game's obviously hugely inspired by (and indebted to) the pioneering *Leaderboard* series by Bruce and Roger Carver, as well as the PC game, *Front Page Sports: Golf*.

I blogged about the game's development (sporadically) here: [Commodore Golf](https://golf-dev.blogspot.com/).

;)




